;
;								EJEMPLO 4
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;Programa combinacional. Simulacin del control de una mquina de torneado
;
;La secuencia se inicia al pulsar "I" (RA0) que activa el cilindro "V" (RB0). Este en su
;avance empuja la pieza a tornear y acciona el sensor "b" (RA2) activando el rel del motor
;"M" (RB1). Comienza el torneado. Durante el avance se alcanza el sensor "c" (RA3) que 
;desactiva el cilindro "V" (RB0) inicindose el retroceso del mismo. Al volver a pasar 
;por "b" (RA2), se desconecta "M" (RB1). Cuando se alcanza el final de carrera "a" (RA1)
;se activa una seal acstica "A" RB2) para que el operario retire la pieza, coloque otra 
;nueva y, se inicie un nuevo ciclo, al pulsar "I" (RA0).
	
		List	p=16F876A	;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

;Estos y otros valores se pueden modificar segn las necesidades

			org		0x00
			goto	Inicio		;Vector de reset
			org		0x05		

Inicio	   	clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A Digital
			movlw	b'00011111'		
			movwf	TRISA		;Puerta A se configura como entrada
			bcf		STATUS,RP0	;Selecciona banco 0			

Loop:		btfsc	PORTA,0		;Chequea si est activado "I"
			goto	Loop		;No, secuencia detenida.
			bcf		PORTB,2		;Si, inicia secuencia, acstico en OFF
			bsf		PORTB,0		;Activa cilindro "V", avance.

Espera_b_1	btfsc	PORTA,2		;Chequea el sensor "b"
			goto	Espera_b_1	;Desactivado, espera.
			bsf		PORTB,1		;"b" activado, motor "M" en ON
Espera_c	btfsc	PORTA,3		;Chequea el sensor "c"
			goto	Espera_c	;Desactivado, espera.
			bcf		PORTB,0		;"c" activado, cilindro "V" en OFF, retroceso
					
Espera_b_2	btfsc	PORTA,2		;Chequea el sensor "b"
			goto	Espera_b_2	;Desactivado, espera
			bcf		PORTB,1		;"b" activado, motor "M" en OFF
				
Espera_a	btfsc	PORTA,1		;Chequea el sensor "a"
			goto	Espera_a	;Desactivado, espera
			bsf		PORTB,2		;"a" activado, acstico en ON
			goto	Loop

			end					;Fin del programa fuente
